// Autor: Frane Kurtovic

#include <iostream>
#include <set>
#include <string>
#include <cassert>
#include <vector>
#include <cmath>

using namespace std;

#define TRACE(x) cout << #x << " = " << x << endl;

void trigrami(set<string>& trigrami, const string &a) {
  string a_h = "#" + a + "#";
  for (int r = 2; r < a_h.size(); r++) {
    trigrami.insert(a_h.substr(r-2, 3));
  }
}

string spoji(const string &l, const string &r) {
  return l.substr(l.size()-1, 1) + string("#") + string(r.substr(0, 1));
}

double slicnost(const string &a, const string &b) {
  set<string> sa, sb;
  return 1;
}

void dodaj(
    const string &trigram,
    set<string>& unija,
    set<string>& presjek,
    const set<string>& sa) {
  assert (trigram.size() == 3);
  unija.insert(trigram);
  if (sa.count(trigram) == 1) {
      presjek.insert(trigram);
  }
}

const double EPS = 1e-9;
int main() {
  set<string> sa;
  int na, nt;
  cin >> na;
  string prev_x = "";
  for (int i = 0; i < na; i++) {
    string x;
    cin >> x;
    trigrami(sa, x);
    if (prev_x != "") {
      sa.insert(spoji(prev_x, x));
    }
    prev_x = x;
  }

  cin >> nt;
  vector <string> t;
  for (int i = 0; i < nt; i++) {
    string s;
    cin >> s;
    t.push_back(s);
  }

  int best_l = -1, best_r = nt;
  double best_val = -1;
  for (int l = 0; l < nt; l++) {
    set <string> unija = sa, presjek;
    // TRACE(unija.size());
    for (int r = l; r < nt; r++) {
      if (r > l) {
        dodaj(spoji(t[r-1], t[r]), unija, presjek, sa); // #X# trigram
      }
      set <string> curr_s;
      trigrami(curr_s, t[r]);

      for (const string &tri : curr_s) {
        dodaj(tri, unija, presjek, sa);
      }

      double val = (double)presjek.size() / unija.size();
      // TRACE(l);
      // TRACE(val);
      // cout << "l " << " val " << val << endl;
      if (val > best_val+EPS) {
        best_val = val;
        best_l = l;
        best_r = r;
      } else if (fabs(val - best_val) <= EPS && r-l < best_r-best_l) {
        best_val = val;
        best_l = l;
        best_r = r;
      }
    }
  }

  for (; best_l <= best_r; best_l++) {
    cout << t[best_l] << " ";
  }
  cout << endl;
  // TRACE(best_l);

  return 0;
}